<?php

require_once('classes/models/clsLine.php');
require_once('classes/models/clsStation.php');
require_once('classes/clsTubeSource.php');

//Utworzenie klienta MySQL
$mySQLConn = @mysql_connect("127.0.0.1", "root", "") or die("Nie mona nawiza poczenia z serwerem MySQL.");
$db = mysql_select_db("metrolondyn", $mySQLConn) or die("Nie mona nawiza poczenia z baz danych metrolondyn.");

// Utworzenie obiektu abstrakcji bazy danych
$tubeSourceObj = new TubeSource($mySQLConn);

$linesArr = $tubeSourceObj->getAllLines();

if ($_GET['line']) {
	$stationsArr = $tubeSourceObj->getStationsByLine($_GET['line']);
}
?>
<html>
<head>
	<title>Stacje londyskiego metra</title>
	<style type="text/css">
	
	</style>
	<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=TWJ_KLUCZ_GOOGLE_MAPS"
      type="text/javascript"></script>

    <script type="text/javascript">

	var g_xmlHttp;
	var g_stationName;
	var g_flickrString;
	var g_map;
	function load() {
		if (GBrowserIsCompatible()) {
			
			var point = null;
			g_map = new GMap2(document.getElementById("map"));
			
			g_map.addControl(new GSmallMapControl());
			g_map.addControl(new GSmallMapControl());
			g_map.setCenter(new GLatLng(51.5099983215, -0.134690001607), 11);
		
<?php if ($_GET['line'] && count($stationsArr) > 0) {
			foreach ($stationsArr as $station) { ?>
  			point = new GLatLng(<?= $station->getLat() ?>, <?= $station->getLong() ?>);
			g_map.addOverlay(createMarker(point, '<?= addslashes($station->getStationName()) ?>'));
<?php } } ?>			
			
		}
    }

	// Utworzenie znacznika w okrelonym punkcie oraz z podan etykiet w postaci liczby
	function createMarker(point, stationName) {
		var marker = new GMarker(point);
		
		GEvent.addListener(marker, "click", function() {
			createXMLHttpRequest();
			g_stationName = stationName;
			retrieveFlickrPhotos(stationName);
			marker.openInfoWindowHtml("<div style=\"width:220px; height:250px;\"><b>" + stationName + "</b><p style=\"text-align:center;\"><img src=\"images/wait.gif\" style=\"padding-top:50px;\" /></p></div>");
			updateInfoBox();
		});
			
		return marker;
	}

	function updateInfoBox() {
		
		if (g_flickrString == undefined) {
			var timeout = window.setTimeout("updateInfoBox()", 3000);
		} else {
			g_map.getInfoWindow().getContentContainers()[0].innerHTML = "<div>" + g_flickrString + "</div>";
			
			// Porzdkowanie
			g_flickrString = null;
			g_stationName = null;
		}
	}


	function retrieveFlickrPhotos(stationName) {
		var url = "services/searchFlickr.php?format=json&nojsoncallback=1&text=" + escape(stationName);
		
		g_xmlHttp.onreadystatechange = parseFlickrSearch;
		g_xmlHttp.open("GET", url, true);
		g_xmlHttp.send(null);
	}

	function parseFlickrSearch() {

		if (g_xmlHttp.readyState == 4) {
			var results = eval('(' + g_xmlHttp.responseText + ')');
			var photo = results.photos.photo;
			var totalPhotos = results.photos.total;
			var l_flickrString = "";
			g_flickrString = "<div><b>" + g_stationName + "</b><br />";
			
			if (totalPhotos > 0) {

				for (x = 0; x < totalPhotos; x++) {
					l_flickrString = "&nbsp;" +
					"<a href='http://www.flickr.com/photos/PHOTO_OWNER/PHOTO_ID' />" +
					"<img src='http://farmPHOTO_FARM.static.flickr.com" +
					"/PHOTO_SERVER/PHOTO_ID_PHOTO_SECRET_s.jpg' border='0' /></a>";
					
					l_flickrString = l_flickrString.replace(/PHOTO_OWNER/g, photo[x].owner);
					l_flickrString = l_flickrString.replace(/PHOTO_ID/g, photo[x].id);
					l_flickrString = l_flickrString.replace(/PHOTO_FARM/g, photo[x].farm);
					l_flickrString = l_flickrString.replace(/PHOTO_SERVER/g, photo[x].server);
					l_flickrString = l_flickrString.replace(/PHOTO_SECRET/g, photo[x].secret);
					
					g_flickrString = g_flickrString + l_flickrString;
				}

			} else {
				g_flickrString = g_flickrString + "<p>Nie znaleziono zdj tej stacji.</p>";
			}
		}
		
	}
	
	function createXMLHttpRequest() {
		if (window.XMLHttpRequest){
          g_xmlHttp = new XMLHttpRequest()
		} else if (window.ActiveXObject) {
          g_xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
   	}
	
    </script>	
	
	
</head>
  <body onload="load()" onunload="GUnload()">
<form name="selectionForm" action="index.php" method="get">
<select name="line">
	<option value="">Wybierz lini</option>
<?php foreach($linesArr as $line) { ?>
	<option value="<?= $line->getLineId() ?>" <?= $_GET['line'] == $line->getLineId() ? " selected=\"selected\"" : "" ?>><?= $line->getLineName() ?></option>
<?php } ?>
</select>
<input type="submit" value="Zatwierd!" />
</form>
    <div id="map" style="width: 800px; height: 600px"></div>

</body>
</html>
